// Copyright 2014 The Android Open Source Project
//
// This software is licensed under the terms of the GNU General Public
// License version 2, as published by the Free Software Foundation, and
// may be copied, distributed, and modified under those terms.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#ifndef ANDROID_UTILS_HOST_BITNESS_H
#define ANDROID_UTILS_HOST_BITNESS_H

#include "android/utils/compiler.h"

ANDROID_BEGIN_HEADER

// Return the bitness of the host machine this program is running on.
// This is independent of whether the current executable is a 32 or 64
// bit binary. Returns 32 or 64.
int android_getHostBitness(void);

ANDROID_END_HEADER

#endif  // ANDROID_UTILS_HOST_BITNESS_H